/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.fabric.platform.configuration;

import com.google.gson.JsonObject;
import java.util.List;
import mod.chiselsandbits.fabric.platform.configuration.FabricConfigurationSource;
import mod.chiselsandbits.fabric.platform.configuration.FabricConfigurationValue;

public final class FabricConfigurationSpec {
    private final FabricConfigurationSource source;
    private final List<FabricConfigurationValue<?>> values;

    public FabricConfigurationSpec(FabricConfigurationSource source, List<FabricConfigurationValue<?>> values) {
        this.source = source;
        this.values = values;
    }

    public void reset() {
        this.source.reset();
        this.values.forEach(FabricConfigurationValue::resetCache);
    }

    public FabricConfigurationSource getSource() {
        return this.source;
    }

    public void loadFrom(JsonObject jsonObject) {
        this.reset();
        this.source.setConfig(jsonObject);
    }

    public void forceGetAll() {
        this.values.forEach(FabricConfigurationValue::get);
    }

    public void writeAll() {
        this.values.forEach(FabricConfigurationValue::write);
    }
}

